/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.npcs.CustomNpcs;
import noppes.npcs.CustomRegisters;
import noppes.npcs.LogWriter;
import noppes.npcs.Server;
import noppes.npcs.api.item.INPCToolItem;
import noppes.npcs.client.Client;
import noppes.npcs.client.NoppesUtil;
import noppes.npcs.client.gui.GuiNpcMobSpawnerAdd;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.constants.EnumPacketServer;
import noppes.npcs.controllers.ServerCloneController;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.entity.EntityNPCInterface;
import noppes.npcs.util.IPermission;
import noppes.npcs.util.Util;

public class ItemNpcCloner
extends Item
implements IPermission,
INPCToolItem {
    public ItemNpcCloner() {
        this.setRegistryName("customnpcs", "npcmobcloner");
        this.func_77655_b("npcmobcloner");
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77637_a(CustomRegisters.tab);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nonnull List<String> list, @Nonnull ITooltipFlag flagIn) {
        list.add(new TextComponentTranslation("info.item.cloner", new Object[0]).func_150254_d());
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Settings", 10)) {
            list.add(new TextComponentTranslation("info.item.cloner.empty.0", new Object[0]).func_150254_d());
            list.add(new TextComponentTranslation("info.item.cloner.empty.1", new Object[0]).func_150254_d());
        } else {
            list.add(new TextComponentTranslation("info.item.cloner.set.0", new Object[]{nbt.func_74775_l("Settings").func_74779_i("Name")}).func_150254_d());
            list.add(new TextComponentTranslation("info.item.cloner.set.1", new Object[0]).func_150254_d());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return super.func_77636_d(stack) || nbt != null && nbt.func_150297_b("Settings", 10) && !nbt.func_74775_l("Settings").func_74779_i("Name").isEmpty();
    }

    @Override
    public boolean isAllowed(EnumPacketServer e) {
        return e == EnumPacketServer.CloneList || e == EnumPacketServer.SpawnMob || e == EnumPacketServer.MobSpawner || e == EnumPacketServer.ClonePreSave || e == EnumPacketServer.CloneRemove || e == EnumPacketServer.CloneSave || e == EnumPacketServer.GetClone || e == EnumPacketServer.Gui;
    }

    @Nonnull
    public EnumActionResult func_180614_a(@Nonnull EntityPlayer player, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            NBTTagCompound nbt;
            PlayerData data = CustomNpcs.proxy.getPlayerData(player);
            boolean summon = false;
            ItemStack stackCloner = player.func_184614_ca();
            if (data != null && data.hud.hasOrKeysPressed(42, 54) && (nbt = stackCloner.func_77978_p()) != null && nbt.func_150297_b("Settings", 10)) {
                NBTTagCompound nbtData = nbt.func_74775_l("Settings");
                if (nbtData.func_74767_n("isServerClone")) {
                    Client.sendData(EnumPacketServer.SpawnMob, true, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), nbtData.func_74779_i("Name"), nbtData.func_74762_e("Tab"));
                } else {
                    Client.sendData(EnumPacketServer.SpawnMob, false, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), nbtData.func_74775_l("EntityNBT"));
                }
                summon = true;
            }
            if (!summon) {
                Entity rayTraceEntity = Util.instance.getLookEntity((Entity)player, 4.0, false);
                if (rayTraceEntity instanceof EntityNPCInterface) {
                    NBTTagCompound compound = new NBTTagCompound();
                    if (!rayTraceEntity.func_184198_c(compound)) {
                        return EnumActionResult.FAIL;
                    }
                    String s = compound.func_74779_i("id");
                    if (s.equals("minecraft:customnpcs.customnpc") || s.equals("minecraft:customnpcs:customnpc")) {
                        compound.func_74778_a("id", "customnpcs:customnpc");
                    }
                    ServerCloneController.Instance.cleanTags(compound);
                    try {
                        if (Server.fillBuffer((ByteBuf)new PacketBuffer(Unpooled.buffer()), EnumPacketClient.CLONE, compound)) {
                            Client.sendData(EnumPacketServer.CloneSet, compound);
                            NoppesUtil.openGUI(player, new GuiNpcMobSpawnerAdd(compound));
                        }
                    }
                    catch (Exception e) {
                        LogWriter.error("Error send data:", e);
                    }
                    return EnumActionResult.FAIL;
                }
                Client.sendData(EnumPacketServer.Gui, new Object[]{EnumGuiType.MobSpawner, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()});
            }
        }
        return EnumActionResult.SUCCESS;
    }
}

